
CREATE DATABASE IF NOT EXISTS voltexpress;
USE voltexpress;

CREATE TABLE usuarios (
 id INT AUTO_INCREMENT PRIMARY KEY,
 nome VARCHAR(100),
 telefone VARCHAR(20),
 email VARCHAR(100),
 senha VARCHAR(255),
 tipo ENUM('cliente','admin','eletricista') DEFAULT 'cliente',
 criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE servicos (
 id INT AUTO_INCREMENT PRIMARY KEY,
 nome VARCHAR(100),
 descricao VARCHAR(255),
 preco DECIMAL(10,2)
);

INSERT INTO servicos (nome,descricao,preco) VALUES
('Emergência Elétrica','24h',200),
('Instalação de Chuveiro','Completa',180),
('Instalação de Interruptor','Simples/paralelo',70),
('Instalação de Lustre','Lustre',120),
('Instalação de Quadro','Quadro de luz',300),
('Instalação de Tomada','Tomada nova',80),
('Ventilador de Teto','Ventilador',150),
('Reparo Elétrico','Reparo geral',120),
('Reparo Disjuntor','Disjuntor',100),
('Troca de Lâmpada','LED',50);

CREATE TABLE solicitacoes (
 id INT AUTO_INCREMENT PRIMARY KEY,
 usuario_id INT,
 servico_id INT,
 descricao TEXT,
 endereco VARCHAR(255),
 valor DECIMAL(10,2),
 status ENUM('pendente','aceito','finalizado') DEFAULT 'pendente',
 criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO usuarios (nome,email,senha,tipo)
VALUES ('Admin','admin@voltexpress.com',MD5('admin123'),'admin');
